IF EXISTS (SELECT * FROM SYS.OBJECTS WHERE NAME = 'UFD_CG_FND_VERBA_RETORNA_VLR')
BEGIN
	DROP FUNCTION UFD_CG_FND_VERBA_RETORNA_VLR
END
GO

CREATE FUNCTION
	DBO.UFD_CG_FND_VERBA_RETORNA_VLR (@CD_EMP INT, @CD_FND_VERBA INT)
RETURNS 
	@RS_RETORNO
TABLE (
	CD_EMP INT,
	CD_FND_VERBA INT,
	VLR_GERADO MONEY,
	VLR_ALOCADO MONEY,
	VLR_SALDO MONEY)  WITH ENCRYPTION
AS
BEGIN
	
	INSERT INTO
		@RS_RETORNO
	SELECT
		CG_FND_VERBA.CD_EMP,
		CG_FND_VERBA.CD_FND_VERBA,
		
		COALESCE(SUM(TBL.VLR_GERADO),0) AS VLR_GERADO,
		COALESCE(SUM(TBL.VLR_ALOCADO),0) AS VLR_ALOCADO,
		COALESCE(SUM(TBL.VLR_GERADO),0) - COALESCE(SUM(VLR_ALOCADO),0) AS VLR_SALDO

	FROM 
		CG_FND_VERBA
		LEFT JOIN (
			SELECT
				V.CD_EMP,
				V.CD_FND_VERBA,
				V.VLR_LANC AS VLR_GERADO,
				0 AS VLR_ALOCADO
			FROM
				CG_FND_VERBA V
			WHERE
				V.CD_EMP = @CD_EMP
				AND V.CD_FND_VERBA = @CD_FND_VERBA
				AND V.TP_LANC = 0

			UNION ALL

			SELECT
				R.CD_EMP,
				R.CD_FND_VERBA,
				0 AS VLR_GERADO,
				SUM(IV.VLR_USO) AS VLR_ALOCADO
			FROM
				CG_FND_VERBA_SAQUE R
				INNER JOIN CG_FND_VERBA_SAQUE_CG_FND_VERBA_USO_PDV_VD_IT V ON
					R.CD_EMP = V.CD_EMP
					AND R.CD_FND_VERBA = V.CD_FND_VERBA
					AND R.CD_FND_VERBA_SAQUE = V.CD_FND_VERBA_SAQUE			
				INNER JOIN CG_FND_VERBA_USO_PDV_VD_IT IV ON
					V.CD_EMP = IV.CD_EMP
					AND V.CD_FILIAL = IV.CD_FILIAL
					AND V.CD_VD = IV.CD_VD
					AND V.CD_IT = IV.CD_IT
					AND V.CD_FND_VERBA_USO = IV.CD_FND_VERBA_USO
			WHERE
				R.CD_EMP = @CD_EMP
				AND R.CD_FND_VERBA = @CD_FND_VERBA
				AND R.STATUS = 0
			GROUP BY
				R.CD_EMP,
				R.CD_FND_VERBA) TBL ON
		CG_FND_VERBA.CD_EMP = TBL.CD_EMP
		AND CG_FND_VERBA.CD_FND_VERBA = TBL.CD_FND_VERBA

	WHERE
		CG_FND_VERBA.CD_EMP = @CD_EMP
		AND CG_FND_VERBA.CD_FND_VERBA = @CD_FND_VERBA
		AND CG_FND_VERBA.TP_LANC = 0
	GROUP BY
		CG_FND_VERBA.CD_EMP,
		CG_FND_VERBA.CD_FND_VERBA,
		CG_FND_VERBA.TP_LANC


	RETURN;
END
